@echo off
title CLSTEAM PC OPTIMIZER - Core Performance Boost
setlocal enabledelayedexpansion

:: Admin Check with proper handling
NET FILE 1>NUL 2>NUL
if not '%errorlevel%' == '0' (
    echo ===============================================
    echo    ADMINISTRATOR PRIVILEGES REQUIRED
    echo ===============================================
    echo.
    echo This script must be run as Administrator!
    echo.
    echo Please right-click on the script and select:
    echo "Run as administrator"
    echo.
    echo Press any key to exit...
    pause >nul
    exit /b 1
)

:Main
cls
echo ===============================================
echo    CLSTEAM PC OPTIMIZER - CORE PERFORMANCE BOOST
echo ===============================================
echo.
echo Starting optimization process with Administrator privileges...
echo.
timeout /t 2 /nobreak >nul

:: System Information
echo [1/20] Gathering System Information...
systeminfo | findstr /C:"Total Physical Memory" /C:"Available Physical Memory" /C:"OS Name" /C:"OS Version" > %temp%\system_info.txt 2>nul
wmic cpu get name /value | findstr "Name" > %temp%\cpu_info.txt 2>nul
wmic computersystem get model /value | findstr "Model" > %temp%\model_info.txt 2>nul

set cpu=Unknown CPU
set memory=Unknown Memory
set model=Unknown Model

if exist "%temp%\cpu_info.txt" (
    for /f "tokens=2 delims==" %%i in (%temp%\cpu_info.txt) do set cpu=%%i
)
if exist "%temp%\system_info.txt" (
    for /f "tokens=2" %%i in ('type "%temp%\system_info.txt" ^| findstr "Physical"') do set memory=%%i
)
if exist "%temp%\model_info.txt" (
    for /f "tokens=2 delims==" %%i in (%temp%\model_info.txt) do set model=%%i
)

echo System Model: !model!
echo Processor: !cpu!
echo Memory: !memory!
echo.
timeout /t 2 /nobreak >nul

:: Clean Temporary Files
echo [2/20] Cleaning Temporary Files...
del /q /f /s %temp%\*.* 2>nul
del /q /f /s C:\Windows\Temp\*.* 2>nul
del /q /f /s C:\Windows\Prefetch\*.* 2>nul
for /d %%x in (%temp%\*) do rd /s /q "%%x" 2>nul
echo [SUCCESS] Temporary files cleaned
echo.

:: Registry Optimization for Performance
echo [3/20] Optimizing Registry for Performance...
reg add "HKLM\SYSTEM\CurrentControlSet\Control\FileSystem" /v "NtfsDisableLastAccessUpdate" /t REG_DWORD /d 1 /f >nul 2>&1 && echo   - File system tracking disabled
reg add "HKLM\SYSTEM\CurrentControlSet\Control\Session Manager\Memory Management" /v "LargeSystemCache" /t REG_DWORD /d 1 /f >nul 2>&1 && echo   - Large system cache enabled
reg add "HKLM\SYSTEM\CurrentControlSet\Control\Session Manager\Memory Management" /v "IOPageLockLimit" /t REG_DWORD /d 4194304 /f >nul 2>&1 && echo   - I/O page lock optimized
reg add "HKLM\SOFTWARE\Microsoft\Windows\CurrentVersion\Explorer" /v "AlwaysUnloadDLL" /t REG_DWORD /d 1 /f >nul 2>&1 && echo   - DLL unloading enabled
echo [SUCCESS] Registry optimization completed
echo.

:: Network Optimization
echo [4/20] Optimizing Network Settings...
reg add "HKLM\SOFTWARE\Microsoft\Windows\CurrentVersion\Internet Settings" /v "MaxConnectionsPerServer" /t REG_DWORD /d 16 /f >nul 2>&1 && echo   - Max connections increased
reg add "HKLM\SOFTWARE\Microsoft\Windows\CurrentVersion\Internet Settings" /v "MaxConnectionsPer1_0Server" /t REG_DWORD /d 16 /f >nul 2>&1 && echo   - HTTP 1.0 connections increased
netsh int tcp set global autotuninglevel=normal >nul 2>&1 && echo   - TCP auto-tuning optimized
netsh int tcp set global rss=enabled >nul 2>&1 && echo   - RSS enabled
echo [SUCCESS] Network optimization completed
echo.

:: Power Plan Optimization
echo [5/20] Setting High Performance Power Plan...
powercfg -setactive 8c5e7fda-e8bf-4a96-9a85-a6e23a8c635c >nul 2>&1
if %errorlevel% equ 0 (
    echo [SUCCESS] High performance power plan activated
) else (
    echo [INFO] Power plan already optimized
)
echo.

:: Memory Optimization
echo [6/20] Optimizing Memory Management...
reg add "HKLM\SYSTEM\CurrentControlSet\Control\Session Manager\Memory Management" /v "ClearPageFileAtShutdown" /t REG_DWORD /d 0 /f >nul 2>&1 && echo   - Page file clearing disabled
reg add "HKLM\SYSTEM\CurrentControlSet\Control\Session Manager\Memory Management" /v "DisablePagingExecutive" /t REG_DWORD /d 1 /f >nul 2>&1 && echo   - Paging executive disabled
echo [SUCCESS] Memory optimization completed
echo.

:: SSD Optimization
echo [7/20] Optimizing SSD Performance...
reg add "HKLM\SYSTEM\CurrentControlSet\Control\FileSystem" /v "DisableDeleteNotification" /t REG_DWORD /d 1 /f >nul 2>&1 && echo   - SSD delete notifications disabled
fsutil behavior set disablelastaccess 1 >nul 2>&1 && echo   - Last access tracking disabled
fsutil behavior set encryptpagingfile 0 >nul 2>&1 && echo   - Page file encryption disabled
echo [SUCCESS] SSD optimization completed
echo.

:: GPU Performance Optimization
echo [8/20] Optimizing GPU Settings...
reg add "HKLM\SOFTWARE\Microsoft\Windows NT\CurrentVersion\Multimedia\SystemProfile" /v "NetworkThrottlingIndex" /t REG_DWORD /d 4294967295 /f >nul 2>&1 && echo   - Network throttling disabled
reg add "HKLM\SOFTWARE\Microsoft\Windows NT\CurrentVersion\Multimedia\SystemProfile\Tasks\Games" /v "GPU Priority" /t REG_DWORD /d 8 /f >nul 2>&1 && echo   - GPU priority increased
echo [SUCCESS] GPU optimization completed
echo.

:: Windows Search Optimization
echo [9/20] Optimizing Windows Search...
reg add "HKLM\SOFTWARE\Microsoft\Windows Search" /v "PreventIndexingOutlook" /t REG_DWORD /d 1 /f >nul 2>&1 && echo   - Outlook indexing prevented
echo [SUCCESS] Search optimization completed
echo.

:: Disable Visual Effects for Performance
echo [10/20] Optimizing Visual Effects...
reg add "HKCU\Software\Microsoft\Windows\CurrentVersion\Explorer\VisualEffects" /v "VisualFXSetting" /t REG_DWORD /d 2 /f >nul 2>&1 && echo   - Visual effects optimized
reg add "HKCU\Control Panel\Desktop" /v "DragFullWindows" /t REG_SZ /d "0" /f >nul 2>&1 && echo   - Full window drag disabled
reg add "HKCU\Control Panel\Desktop" /v "MenuShowDelay" /t REG_SZ /d "0" /f >nul 2>&1 && echo   - Menu delay removed
echo [SUCCESS] Visual effects optimized
echo.

:: Process Priority Optimization
echo [11/20] Optimizing Process Priorities...
wmic process where name="explorer.exe" call setpriority "high" >nul 2>&1 && echo   - Explorer priority increased
echo [SUCCESS] Process priorities optimized
echo.

:: DNS Optimization
echo [12/20] Setting Fast DNS Servers...
netsh interface ip set dns name="Ethernet" source=static addr=8.8.8.8 >nul 2>&1 && echo   - Primary DNS set for Ethernet
netsh interface ip add dns name="Ethernet" addr=8.8.4.4 index=2 >nul 2>&1 && echo   - Secondary DNS set for Ethernet
netsh interface ip set dns name="Wi-Fi" source=static addr=8.8.8.8 >nul 2>&1 && echo   - Primary DNS set for Wi-Fi
netsh interface ip add dns name="Wi-Fi" addr=8.8.4.4 index=2 >nul 2>&1 && echo   - Secondary DNS set for Wi-Fi
echo [SUCCESS] DNS optimization completed
echo.

:: System File Check
echo [13/20] Running System File Check...
echo [INFO] This may take several minutes...
sfc /scannow >nul 2>&1
echo [SUCCESS] System file check completed
echo.

:: Disk Cleanup
echo [14/20] Running Disk Cleanup...
cleanmgr /sagerun:1 >nul 2>&1
echo [SUCCESS] Disk cleanup completed
echo.

:: Disk Defragmentation
echo [15/20] Optimizing Disk Performance...
defrag C: /O /U >nul 2>&1
echo [SUCCESS] Disk optimization completed
echo.

:: Final System Flush
echo [16/20] Performing Final System Optimization...
ipconfig /flushdns >nul 2>&1 && echo   - DNS cache flushed
netsh winsock reset catalog >nul 2>&1 && echo   - Winsock catalog reset
netsh int ip reset >nul 2>&1 && echo   - IP stack reset
echo [SUCCESS] System flush completed
echo.

:: Windows Update Optimization
echo [17/20] Optimizing Windows Update...
reg add "HKLM\SOFTWARE\Policies\Microsoft\Windows\WindowsUpdate\AU" /v "NoAutoUpdate" /t REG_DWORD /d 0 /f >nul 2>&1 && echo   - AutoUpdate configured
echo [SUCCESS] Windows Update optimized
echo.

:: Services Optimization (Performance tuning only - no disabling)
echo [18/20] Tuning Services for Performance...
sc config "SysMain" start=auto >nul 2>&1 && echo   - SysMain service optimized
sc config "WSearch" start=auto >nul 2>&1 && echo   - Windows Search optimized
echo [SUCCESS] Services tuning completed
echo.

:: Game Mode Optimization
echo [19/20] Enabling Game Mode...
reg add "HKCU\Software\Microsoft\GameBar" /v "AllowAutoGameMode" /t REG_DWORD /d 1 /f >nul 2>&1 && echo   - Auto Game Mode enabled
reg add "HKCU\System\GameConfigStore" /v "GameDVR_Enabled" /t REG_DWORD /d 0 /f >nul 2>&1 && echo   - Game DVR disabled
echo [SUCCESS] Game Mode optimization completed
echo.

:: Final Cleanup
echo [20/20] Performing Final Cleanup...
del /q /f %temp%\system_info.txt >nul 2>&1
del /q /f %temp%\cpu_info.txt >nul 2>&1
del /q /f %temp%\model_info.txt >nul 2>&1
echo [SUCCESS] Cleanup completed
echo.

:: Completion Message
echo ===============================================
echo    OPTIMIZATION COMPLETE!
echo ===============================================
echo.
echo All optimizations have been successfully applied!
echo.
echo Summary of optimizations performed:
echo ✓ Temporary files cleaned
echo ✓ Registry optimized for performance
echo ✓ Network settings tuned
echo ✓ High performance power plan activated
echo ✓ Memory management optimized
echo ✓ SSD performance enhanced
echo ✓ GPU settings optimized
echo ✓ Visual effects adjusted for performance
echo ✓ Process priorities optimized
echo ✓ DNS servers optimized
echo ✓ System files verified
echo ✓ Disk performance optimized
echo ✓ Windows Update optimized
echo ✓ Services tuned for performance
echo ✓ Game Mode enabled
echo.
echo IMPORTANT: Restart your computer for all changes to take effect.
echo.
echo CLSTEAM PC OPTIMIZER - Core Performance Boost
echo Optimization completed at: %date% %time%
echo ===============================================
echo.
echo Press Enter to exit...
pause >nul
exit